/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle.packs;

import com.redpxnda.respawnobelisks.registry.particle.packs.IBasicPack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.TriFunction;

public class SimpleRingPack
implements IBasicPack {
    public final ParticleOptions particle;
    public int increase;
    public int max;
    public TriFunction<Double, Integer, Double, Double> hFunc;
    public TriFunction<Double, Integer, Double, Double> vFunc;
    public TriFunction<Double, Integer, Double, Double> hSpeedFunc;
    public TriFunction<Double, Integer, Double, Double> vSpeedFunc;
    public TriFunction<Double, Integer, Double, Double> hFuncDecrease;
    public TriFunction<Double, Integer, Double, Double> vFuncDecrease;
    public TriFunction<Double, Integer, Double, Double> hSpeedFuncDecrease;
    public TriFunction<Double, Integer, Double, Double> vSpeedFuncDecrease;
    public boolean shouldChangeY = true;
    public double chargeRadius = 3.0;
    public double depleteRadius = 0.5;

    public void setHorizFuncs(TriFunction<Double, Integer, Double, Double> hFunc) {
        this.hFunc = hFunc;
        this.hFuncDecrease = hFunc;
    }

    public void setVertFuncs(TriFunction<Double, Integer, Double, Double> vFunc) {
        this.vFunc = vFunc;
        this.vFuncDecrease = vFunc;
    }

    public void setHorizSpeedFuncs(TriFunction<Double, Integer, Double, Double> hSpeedFunc) {
        this.hSpeedFunc = hSpeedFunc;
        this.hSpeedFuncDecrease = hSpeedFunc;
    }

    public void setVertSpeedFuncs(TriFunction<Double, Integer, Double, Double> vSpeedFunc) {
        this.vSpeedFunc = vSpeedFunc;
        this.vSpeedFuncDecrease = vSpeedFunc;
    }

    public SimpleRingPack(ParticleOptions particle) {
        this.particle = particle;
        this.increase = 5;
        this.max = 360;
        this.setVertSpeedFuncs((TriFunction<Double, Integer, Double, Double>)((TriFunction)(d0, i, d1) -> d0));
        this.setHorizSpeedFuncs((TriFunction<Double, Integer, Double, Double>)((TriFunction)(d0, i, d1) -> d0));
        this.setHorizFuncs((TriFunction<Double, Integer, Double, Double>)((TriFunction)(d0, i, d1) -> d0));
        this.setVertFuncs((TriFunction<Double, Integer, Double, Double>)((TriFunction)(d0, i, d1) -> d0));
    }

    @Override
    public void depleteAnimation(Level level, Player player, BlockPos blockPos) {
        for (int i = 0; i < this.max; i += this.increase) {
            double radians = (double)i * Math.PI / 180.0;
            double x = (Double)this.hFuncDecrease.apply((Object)((double)blockPos.m_123341_() + Math.sin(radians) * this.depleteRadius + 0.5), (Object)i, (Object)radians);
            double y = (Double)this.vFuncDecrease.apply((Object)((double)blockPos.m_123342_() + (this.shouldChangeY ? 1.6 : 0.0)), (Object)i, (Object)radians);
            double z = (Double)this.hFuncDecrease.apply((Object)((double)blockPos.m_123343_() + Math.cos(radians) * this.depleteRadius + 0.5), (Object)i, (Object)radians);
            double xSpeed = (Double)this.hSpeedFuncDecrease.apply((Object)(Math.sin(radians) / 5.0), (Object)i, (Object)radians);
            double ySpeed = (Double)this.vSpeedFuncDecrease.apply((Object)-0.05, (Object)i, (Object)radians);
            double zSpeed = (Double)this.hSpeedFuncDecrease.apply((Object)(Math.cos(radians) / 5.0), (Object)i, (Object)radians);
            level.m_7106_(this.particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    public void chargeAnimation(Level level, Player player, BlockPos blockPos) {
        for (int i = 0; i < this.max; i += this.increase) {
            double radians = (double)i * Math.PI / 180.0;
            double x = (Double)this.hFunc.apply((Object)((double)blockPos.m_123341_() + Math.sin(radians) * this.chargeRadius + 0.5), (Object)i, (Object)radians);
            double y = (Double)this.vFunc.apply((Object)((double)blockPos.m_123342_() + (this.shouldChangeY ? 0.7 : 0.0)), (Object)i, (Object)radians);
            double z = (Double)this.hFunc.apply((Object)((double)blockPos.m_123343_() + Math.cos(radians) * this.chargeRadius + 0.5), (Object)i, (Object)radians);
            double xSpeed = (Double)this.hSpeedFunc.apply((Object)(-Math.sin(radians) / 5.0), (Object)i, (Object)radians);
            double ySpeed = (Double)this.vSpeedFunc.apply((Object)0.05, (Object)i, (Object)radians);
            double zSpeed = (Double)this.hSpeedFunc.apply((Object)(-Math.cos(radians) / 5.0), (Object)i, (Object)radians);
            level.m_7106_(this.particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

